set autoscale 
set xtic auto 
set ytic auto 
set style line  1 lt 1 lw 1 lc rgb "#000000"
set style line  2 lt 1 lw 1 lc rgb "#FF0000"
set style line  3 lt 1 lw 3 lc rgb "#000000"

set terminal postscript portrait enhanced color  "Times" 12
 
set xlabel "Energy (units of t)" font "Times,12"
set ylabel "Intensity (states per eV)" font "Times,12"
 
set out 'G0.ps'
 
plot "G0IPES.dat" using ( $1):(-$3/pi) title 'G0( w) IPES up' with lines ls 1,\
     "G0IPES.dat" using ( $1):(-$5/pi) title 'G0( w) IPES dn' with lines ls 1,\
     "G0PES.dat"  using (-$1):(-$3/pi) title 'G0(-w)  PES up' with lines ls 2,\
     "G0PEs.dat"  using (-$1):(-$5/pi) title 'G0(-w)  PES dn' with lines ls 2
 
plot "G0BrIPES.dat" using ( $1):(-$3/pi) title 'G0( w) IPES up' with lines ls 1,\
     "G0BrIPES.dat" using ( $1):(-$5/pi) title 'G0( w) IPES dn' with lines ls 1,\
     "G0BrPES.dat"  using (-$1):(-$3/pi) title 'G0(-w)  PES up' with lines ls 2,\
     "G0BrPEs.dat"  using (-$1):(-$5/pi) title 'G0(-w)  PES dn' with lines ls 2
 
